package w83b.w83bOperacionesPaso.w83bMantenimientos.w83bPlantillas;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


import w83b.w83bBeans.W83bPlantillasBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaPlantillasExcelAction.
 *
 * @author jrgil
 */
public class W83bTablaPlantillasExcelAction extends Q70ActionPasoOP{


	
	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
		W83bPlantillasBean plantillasBean = (W83bPlantillasBean)contexto.get("w83bPlantillasBean");
		plantillasBean.setIdFase(request.getParameter("fase"));
		if(!"".equalsIgnoreCase(request.getParameter("fase"))){
			plantillasBean.setDescFase((String) contexto.get("descfase"));
		}
		plantillasBean.setIdTramite(request.getParameter("tramite"));
		if(!"".equalsIgnoreCase(request.getParameter("tramite"))){
			plantillasBean.setDescTramite((String) contexto.get("desctramite"));
		}
		contexto.set("w83bPlantillasTempBean",plantillasBean);
	}

	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoPlantillas.xls";
		InputStream inputStream = W83bTablaPlantillasExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaPlantillas = (ArrayList)contexto.get("w83bListaPlantillas");
        W83bPlantillasBean plantillasBean = (W83bPlantillasBean)contexto.get("w83bPlantillasTempBean");        
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);        

        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);        
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);        
               
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));        
        HashMap mapaPlantillas=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);        
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1        
        HSSFCell cell = row.createCell((short)3);        
        row = sheet.getRow((short)4);        
        cell = row.getCell((short)2);        
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaPlantillas.get("tituloDepEs");        
        StringBuffer tituloImagenEu =  (StringBuffer)mapaPlantillas.get("tituloDepEu");        
        cell.setCellValue(tituloImagenEu.toString());        
        
        cell = row.getCell((short)6);        
        cell.setCellValue(tituloImagenEs.toString());        
        
        tituloImagenEs = (StringBuffer)mapaPlantillas.get("tituloDelelegacionEs");        
        tituloImagenEu = (StringBuffer)mapaPlantillas.get("tituloDelelegacionEu");        

        row = sheet.getRow((short)6);        
        cell = row.getCell((short)2);        
        cell.setCellValue(tituloImagenEu.toString());        
        
        cell = row.getCell((short)6);        
        cell.setCellValue(tituloImagenEs.toString());        
        
        row = sheet.getRow((short)9);        
        cell = row.getCell((short)0);        
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.plantillas.listadoPlantillas").toUpperCase());        

        //MAPEO FORMULARIO
      //fila 13, columna 2
        row = sheet.getRow((short)12);
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.plantillas.nombreTabla"));
        
        cell = row.createCell((short)2);

        if(StringUtils.isNotEmpty(plantillasBean.getNombrePlantilla())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("2"),W83bClsConstantes.DOCE,Short.parseShort("6")));//NOPMD
        	if(StringUtils.isNotEmpty(plantillasBean.getNombrePlantilla())){
        		cell.setCellValue(plantillasBean.getNombrePlantilla().toUpperCase());
        	}
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
      //fila 14, columna 2
        row = sheet.getRow((short)13);
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.plantillas.codFaseBusqTabla"));
        cell = row.createCell((short)2);

        if(StringUtils.isNotEmpty(plantillasBean.getDescFase())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("2"),W83bClsConstantes.TRECE,Short.parseShort("5")));//NOPMD
        	if(StringUtils.isNotEmpty(plantillasBean.getDescFase())){
        		cell.setCellValue(plantillasBean.getDescFase().toUpperCase());
        	}
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
      //fila 14, columna 5
        cell = row.getCell((short)6);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.plantillas.codTramiteBusqTabla"));
        
        
        cell = row.createCell((short)8);

        if(StringUtils.isNotEmpty(plantillasBean.getDescTramite())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("8"),W83bClsConstantes.TRECE,Short.parseShort("10")));//NOPMD
        	if(StringUtils.isNotEmpty(plantillasBean.getDescTramite())){
        		cell.setCellValue(plantillasBean.getDescTramite().toUpperCase());
        	}
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        //fila 15, columna 2
        row = sheet.getRow((short)14);
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.plantillas.descBusqTabla"));
        
        cell = row.createCell((short)2);
        if(StringUtils.isNotEmpty(plantillasBean.getDescripcion())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("2"),W83bClsConstantes.CATORCE,Short.parseShort("5")));//NOPMD
        	if(StringUtils.isNotEmpty(plantillasBean.getDescripcion())){
        		cell.setCellValue(plantillasBean.getDescripcion().toUpperCase());
        	}
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        }else{
        	cell.setCellValue(plantillasBean.getDescripcion());
        }
      //fila 15, columna 5
        cell = row.getCell((short)6);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.plantillas.descEuskBusqTabla"));
        
        cell = row.createCell((short)8);
        if(StringUtils.isNotEmpty(plantillasBean.getDescripcion_eusk())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("8"),W83bClsConstantes.CATORCE,Short.parseShort("10")));//NOPMD
        	if(StringUtils.isNotEmpty(plantillasBean.getDescripcion_eusk())){
        		cell.setCellValue(plantillasBean.getDescripcion_eusk().toUpperCase());
        	}
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        }else{
        	if(StringUtils.isNotEmpty(plantillasBean.getDescripcion_eusk())){
        		cell.setCellValue(plantillasBean.getDescripcion_eusk());
        	}
        }
    	
        if(StringUtils.isNotEmpty(plantillasBean.getDescripcion()) && StringUtils.isNotEmpty(plantillasBean.getDescripcion_eusk())){
	    	if((plantillasBean.getDescripcion()).length()+20>=(plantillasBean.getDescripcion_eusk()).length()){
		        if(52<(plantillasBean.getDescripcion()).length()){
		        	row.setHeightInPoints((short)(22*((plantillasBean.getDescripcion()).length()/52)+1));
		        }
	        }else{
	        	if(72<(plantillasBean.getDescripcion_eusk()).length()){
	        		row.setHeightInPoints((short)(22*((plantillasBean.getDescripcion_eusk()).length()/72)+1));
	        	}
	        }
        }
        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamanyo columna en chars)/(1/20)
        row = sheet.getRow((short)W83bClsConstantes.DIECISIETE); // Creacin de la fila 16
        cell = row.getCell((short)0); // Creacin de la columna 2 para la fila 16
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.plantillas.nombreTabla"));
        
        cell = row.getCell((short)1); // Creacin de la columna 3 para la fila 16
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.plantillas.codFaseBusqTabla"));
        
        cell = row.getCell((short)3); // Creacin de la columna 4 para la fila 16
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.plantillas.codTramiteBusqTabla"));
        
        cell = row.getCell((short)6); // Creacin de la columna 5 para la fila 16
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.plantillas.descBusqTabla"));

        cell = row.getCell((short)9); // Creacin de la columna 6 para la fila 16
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.plantillas.descEuskBusqTabla"));
        

        for(int i=0;i<listaPlantillas.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.DIECIOCHO+i); // Creacin de la fila 17
        	
        

        	//Nombre plantilla
        	cell = row.createCell((short)0);
        	if(StringUtils.isNotEmpty(((W83bPlantillasBean)listaPlantillas.get(i)).getNombrePlantilla())){
        		cell.setCellValue(((W83bPlantillasBean)listaPlantillas.get(i)).getNombrePlantilla().toUpperCase());
            }else{
            	cell.setCellValue("");
            }
        	
        	cell.setCellStyle(estiloFila(i,excel));

        	//descripcin fase
        	cell = row.createCell((short)1);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("1"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("2")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bPlantillasBean)listaPlantillas.get(i)).getDescFase())){
        		cell.setCellValue(((W83bPlantillasBean)listaPlantillas.get(i)).getDescFase().toUpperCase());
            }else{
            	cell.setCellValue("");
            }
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell((short)2);
        	cell.setCellStyle(estiloFila(i,excel));

        	//Descripcin tramite
        	cell = row.createCell((short)3);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("3"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("5")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bPlantillasBean)listaPlantillas.get(i)).getDescTramite())){
        		cell.setCellValue(((W83bPlantillasBean)listaPlantillas.get(i)).getDescTramite().toUpperCase());
            }else{
            	cell.setCellValue("");
            }
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell((short)4);
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell((short)5);
        	cell.setCellStyle(estiloFila(i,excel));

        	//Descripcin plantilla castellano
        	cell = row.createCell((short)6);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("6"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("8")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bPlantillasBean)listaPlantillas.get(i)).getDescripcion())){
        		cell.setCellValue(((W83bPlantillasBean)listaPlantillas.get(i)).getDescripcion().toUpperCase());
            }else{
            	cell.setCellValue("");
            }
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("7")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("8")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	//Descripcin plantilla euskera
        	cell = row.createCell((short)9);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("9"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("10")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bPlantillasBean)listaPlantillas.get(i)).getDescripcion_eusk())){
        		cell.setCellValue(((W83bPlantillasBean)listaPlantillas.get(i)).getDescripcion_eusk().toUpperCase());
            }else{
            	cell.setCellValue("");
            }
        	cell.setCellStyle(estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("10")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	if(((W83bPlantillasBean)listaPlantillas.get(i)).getDescripcion().length()>=((W83bPlantillasBean)listaPlantillas.get(i)).getDescripcion_eusk().length()){        	
	        	if(62<(((W83bPlantillasBean)listaPlantillas.get(i)).getDescripcion()).length()){
	        		row.setHeightInPoints((short)(20*((((W83bPlantillasBean)listaPlantillas.get(i)).getDescripcion()).length()/62)+1));
	        	}
	        }else{
	        	if(62<(((W83bPlantillasBean)listaPlantillas.get(i)).getDescripcion_eusk()).length()){
	        		row.setHeightInPoints((short)(20*((((W83bPlantillasBean)listaPlantillas.get(i)).getDescripcion_eusk()).length()/62)+1));
	        	}
	        }
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoPlantillas.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		return null;
	}
	

	/**
	 * Estilo fila.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
}